using System;
using System.IO;
using System.Linq;
using System.Collections.Generic;

class Program
{
    struct Mast
    {
        public long x, h;
        public int idx;
    }

    static void Main()
    {
        var sr = new StreamReader(Console.OpenStandardInput());
        int n = int.Parse(sr.ReadLine());
        long[] xs = sr.ReadLine().Split().Select(long.Parse).ToArray();
        long[] hs = sr.ReadLine().Split().Select(long.Parse).ToArray();

        Mast[] m = new Mast[n];
        for (int i = 0; i < n; i++)
            m[i] = new Mast { x = xs[i], h = hs[i], idx = i };

        // Sort by x
        Array.Sort(m, (a, b) => a.x.CompareTo(b.x));

        const long INF = long.MaxValue / 4;
        long[] ans = Enumerable.Repeat(INF, n).ToArray();

        // Nearest higher or equal on the left
        Stack<int> st = new Stack<int>();
        for (int i = 0; i < n; i++)
        {
            while (st.Count > 0 && m[st.Peek()].h < m[i].h)
                st.Pop();
            if (st.Count > 0)
                ans[m[i].idx] = Math.Min(ans[m[i].idx],
                    Math.Abs(m[i].x - m[st.Peek()].x));
            st.Push(i);
        }

        // Nearest higher or equal on the right
        st.Clear();
        for (int i = n - 1; i >= 0; i--)
        {
            while (st.Count > 0 && m[st.Peek()].h < m[i].h)
                st.Pop();
            if (st.Count > 0)
                ans[m[i].idx] = Math.Min(ans[m[i].idx],
                    Math.Abs(m[i].x - m[st.Peek()].x));
            st.Push(i);
        }

        // Rope contributions
        for (int i = 0; i + 1 < n; i++)
        {
            long dx = m[i + 1].x - m[i].x;
            long peak2 = dx + m[i].h + m[i + 1].h; // 2 * H

            // Left mast
            if (peak2 >= 2 * m[i].h)
            {
                long d = (peak2 - 2 * m[i].h) / 2;
                ans[m[i].idx] = Math.Min(ans[m[i].idx], d);
            }

            // Right mast
            if (peak2 >= 2 * m[i + 1].h)
            {
                long d = (peak2 - 2 * m[i + 1].h) / 2;
                ans[m[i + 1].idx] = Math.Min(ans[m[i + 1].idx], d);
            }
        }

        // Output
        var sw = new StreamWriter(Console.OpenStandardOutput());
        for (int i = 0; i < n; i++)
        {
            if (ans[i] == INF) sw.WriteLine("-1");
            else sw.WriteLine(ans[i]);
        }
        sw.Flush();
    }
}